package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDetectKeyPhrasesResponse(
    resultList: Iterable[
      zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult
    ],
    errorList: Iterable[zio.aws.comprehend.model.BatchItemError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse = {
    import BatchDetectKeyPhrasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse
      .builder()
      .resultList(resultList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorList(errorList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly =
    zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.wrap(buildAwsValue())
}
object BatchDetectKeyPhrasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse =
      zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse(
        resultList.map { item =>
          item.asEditable
        },
        errorList.map { item =>
          item.asEditable
        }
      )
    def resultList: List[
      zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult.ReadOnly
    ]
    def errorList: List[zio.aws.comprehend.model.BatchItemError.ReadOnly]
    def getResultList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult.ReadOnly
    ]] = ZIO.succeed(resultList)
    def getErrorList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchItemError.ReadOnly
    ]] = ZIO.succeed(errorList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse
  ) extends zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly {
    override val resultList: List[
      zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult.ReadOnly
    ] = impl
      .resultList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult.wrap(item)
      }
      .toList
    override val errorList
        : List[zio.aws.comprehend.model.BatchItemError.ReadOnly] = impl
      .errorList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchItemError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse
  ): zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly =
    new Wrapper(impl)
}
