package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendEndpointArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateEndpointResponse(
    endpointArn: Option[ComprehendEndpointArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse = {
    import CreateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
      .builder()
      .optionallyWith(
        endpointArn.map(value =>
          ComprehendEndpointArn.unwrap(value): java.lang.String
        )
      )(_.endpointArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly =
    zio.aws.comprehend.model.CreateEndpointResponse.wrap(buildAwsValue())
}
object CreateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateEndpointResponse =
      zio.aws.comprehend.model
        .CreateEndpointResponse(endpointArn.map(value => value))
    def endpointArn: Option[ComprehendEndpointArn]
    def getEndpointArn: ZIO[Any, AwsError, ComprehendEndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
  ) extends zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly {
    override val endpointArn: Option[ComprehendEndpointArn] = scala
      .Option(impl.endpointArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendEndpointArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse
  ): zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
