package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ClassifierMetadata(
    numberOfLabels: Option[Integer] = None,
    numberOfTrainedDocuments: Option[Integer] = None,
    numberOfTestDocuments: Option[Integer] = None,
    evaluationMetrics: Option[
      zio.aws.comprehend.model.ClassifierEvaluationMetrics
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ClassifierMetadata = {
    import ClassifierMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ClassifierMetadata
      .builder()
      .optionallyWith(numberOfLabels.map(value => value: java.lang.Integer))(
        _.numberOfLabels
      )
      .optionallyWith(
        numberOfTrainedDocuments.map(value => value: java.lang.Integer)
      )(_.numberOfTrainedDocuments)
      .optionallyWith(
        numberOfTestDocuments.map(value => value: java.lang.Integer)
      )(_.numberOfTestDocuments)
      .optionallyWith(evaluationMetrics.map(value => value.buildAwsValue()))(
        _.evaluationMetrics
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ClassifierMetadata.ReadOnly =
    zio.aws.comprehend.model.ClassifierMetadata.wrap(buildAwsValue())
}
object ClassifierMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ClassifierMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ClassifierMetadata =
      zio.aws.comprehend.model.ClassifierMetadata(
        numberOfLabels.map(value => value),
        numberOfTrainedDocuments.map(value => value),
        numberOfTestDocuments.map(value => value),
        evaluationMetrics.map(value => value.asEditable)
      )
    def numberOfLabels: Option[Integer]
    def numberOfTrainedDocuments: Option[Integer]
    def numberOfTestDocuments: Option[Integer]
    def evaluationMetrics
        : Option[zio.aws.comprehend.model.ClassifierEvaluationMetrics.ReadOnly]
    def getNumberOfLabels: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfLabels", numberOfLabels)
    def getNumberOfTrainedDocuments: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("numberOfTrainedDocuments", numberOfTrainedDocuments)
    def getNumberOfTestDocuments: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfTestDocuments", numberOfTestDocuments)
    def getEvaluationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.ClassifierEvaluationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationMetrics", evaluationMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifierMetadata
  ) extends zio.aws.comprehend.model.ClassifierMetadata.ReadOnly {
    override val numberOfLabels: Option[Integer] =
      scala.Option(impl.numberOfLabels()).map(value => value: Integer)
    override val numberOfTrainedDocuments: Option[Integer] =
      scala.Option(impl.numberOfTrainedDocuments()).map(value => value: Integer)
    override val numberOfTestDocuments: Option[Integer] =
      scala.Option(impl.numberOfTestDocuments()).map(value => value: Integer)
    override val evaluationMetrics: Option[
      zio.aws.comprehend.model.ClassifierEvaluationMetrics.ReadOnly
    ] = scala
      .Option(impl.evaluationMetrics())
      .map(value =>
        zio.aws.comprehend.model.ClassifierEvaluationMetrics.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifierMetadata
  ): zio.aws.comprehend.model.ClassifierMetadata.ReadOnly = new Wrapper(impl)
}
