package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDocumentClassificationJobsResponse(
    documentClassificationJobPropertiesList: Option[
      Iterable[zio.aws.comprehend.model.DocumentClassificationJobProperties]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse = {
    import ListDocumentClassificationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse
      .builder()
      .optionallyWith(
        documentClassificationJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentClassificationJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListDocumentClassificationJobsResponse
      .wrap(buildAwsValue())
}
object ListDocumentClassificationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListDocumentClassificationJobsResponse =
      zio.aws.comprehend.model.ListDocumentClassificationJobsResponse(
        documentClassificationJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def documentClassificationJobPropertiesList: Option[List[
      zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
    ]]
    def nextToken: Option[String]
    def getDocumentClassificationJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentClassificationJobPropertiesList",
      documentClassificationJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse
  ) extends zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly {
    override val documentClassificationJobPropertiesList: Option[List[
      zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
    ]] = scala
      .Option(impl.documentClassificationJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentClassificationJobProperties
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse
  ): zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly =
    new Wrapper(impl)
}
