package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SentimentScore(
    positive: Option[Float] = None,
    negative: Option[Float] = None,
    neutral: Option[Float] = None,
    mixed: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.SentimentScore = {
    import SentimentScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.SentimentScore
      .builder()
      .optionallyWith(positive.map(value => value: java.lang.Float))(_.positive)
      .optionallyWith(negative.map(value => value: java.lang.Float))(_.negative)
      .optionallyWith(neutral.map(value => value: java.lang.Float))(_.neutral)
      .optionallyWith(mixed.map(value => value: java.lang.Float))(_.mixed)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.SentimentScore.ReadOnly =
    zio.aws.comprehend.model.SentimentScore.wrap(buildAwsValue())
}
object SentimentScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.SentimentScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.SentimentScore =
      zio.aws.comprehend.model.SentimentScore(
        positive.map(value => value),
        negative.map(value => value),
        neutral.map(value => value),
        mixed.map(value => value)
      )
    def positive: Option[Float]
    def negative: Option[Float]
    def neutral: Option[Float]
    def mixed: Option[Float]
    def getPositive: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("positive", positive)
    def getNegative: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("negative", negative)
    def getNeutral: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("neutral", neutral)
    def getMixed: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("mixed", mixed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.SentimentScore
  ) extends zio.aws.comprehend.model.SentimentScore.ReadOnly {
    override val positive: Option[Float] =
      scala.Option(impl.positive()).map(value => value: Float)
    override val negative: Option[Float] =
      scala.Option(impl.negative()).map(value => value: Float)
    override val neutral: Option[Float] =
      scala.Option(impl.neutral()).map(value => value: Float)
    override val mixed: Option[Float] =
      scala.Option(impl.mixed()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.SentimentScore
  ): zio.aws.comprehend.model.SentimentScore.ReadOnly = new Wrapper(impl)
}
