package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait ModelStatus {
  def unwrap: software.amazon.awssdk.services.comprehend.model.ModelStatus
}
object ModelStatus {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.ModelStatus
  ): zio.aws.comprehend.model.ModelStatus = value match {
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.TRAINING =>
      val r = TRAINING
      r
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.STOP_REQUESTED =>
      val r = STOP_REQUESTED
      r
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.IN_ERROR =>
      val r = IN_ERROR
      r
    case software.amazon.awssdk.services.comprehend.model.ModelStatus.TRAINED =>
      val r = TRAINED
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.SUBMITTED
  }
  case object TRAINING extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.TRAINING
  }
  case object DELETING extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.DELETING
  }
  case object STOP_REQUESTED extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.STOP_REQUESTED
  }
  case object STOPPED extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.STOPPED
  }
  case object IN_ERROR extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.IN_ERROR
  }
  case object TRAINED extends zio.aws.comprehend.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.ModelStatus =
      software.amazon.awssdk.services.comprehend.model.ModelStatus.TRAINED
  }
}
