package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerMetadata(
    numberOfTrainedDocuments: Option[Integer] = None,
    numberOfTestDocuments: Option[Integer] = None,
    evaluationMetrics: Option[
      zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics
    ] = None,
    entityTypes: Option[Iterable[
      zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadata = {
    import EntityRecognizerMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadata
      .builder()
      .optionallyWith(
        numberOfTrainedDocuments.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.numberOfTrainedDocuments)
      .optionallyWith(
        numberOfTestDocuments.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.numberOfTestDocuments)
      .optionallyWith(evaluationMetrics.map(value => value.buildAwsValue()))(
        _.evaluationMetrics
      )
      .optionallyWith(
        entityTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entityTypes)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerMetadata.wrap(buildAwsValue())
}
object EntityRecognizerMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerMetadata =
      zio.aws.comprehend.model.EntityRecognizerMetadata(
        numberOfTrainedDocuments.map(value => value),
        numberOfTestDocuments.map(value => value),
        evaluationMetrics.map(value => value.asEditable),
        entityTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numberOfTrainedDocuments: Option[Integer]
    def numberOfTestDocuments: Option[Integer]
    def evaluationMetrics: Option[
      zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics.ReadOnly
    ]
    def entityTypes: Option[List[
      zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly
    ]]
    def getNumberOfTrainedDocuments: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("numberOfTrainedDocuments", numberOfTrainedDocuments)
    def getNumberOfTestDocuments: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfTestDocuments", numberOfTestDocuments)
    def getEvaluationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationMetrics", evaluationMetrics)
    def getEntityTypes: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("entityTypes", entityTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadata
  ) extends zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly {
    override val numberOfTrainedDocuments: Option[Integer] = scala
      .Option(impl.numberOfTrainedDocuments())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val numberOfTestDocuments: Option[Integer] = scala
      .Option(impl.numberOfTestDocuments())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val evaluationMetrics: Option[
      zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics.ReadOnly
    ] = scala
      .Option(impl.evaluationMetrics())
      .map(value =>
        zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics.wrap(value)
      )
    override val entityTypes: Option[List[
      zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly
    ]] = scala
      .Option(impl.entityTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadata
  ): zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly = new Wrapper(
    impl
  )
}
