package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDominantLanguageDetectionJobResponse(
    dominantLanguageDetectionJobProperties: Option[
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse = {
    import DescribeDominantLanguageDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse
      .builder()
      .optionallyWith(
        dominantLanguageDetectionJobProperties.map(value =>
          value.buildAwsValue()
        )
      )(_.dominantLanguageDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeDominantLanguageDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse =
      zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse(
        dominantLanguageDetectionJobProperties.map(value => value.asEditable)
      )
    def dominantLanguageDetectionJobProperties: Option[
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
    ]
    def getDominantLanguageDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dominantLanguageDetectionJobProperties",
      dominantLanguageDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly {
    override val dominantLanguageDetectionJobProperties: Option[
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
    ] = scala
      .Option(impl.dominantLanguageDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.DominantLanguageDetectionJobProperties
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
