package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDetectSentimentResponse(
    resultList: Iterable[
      zio.aws.comprehend.model.BatchDetectSentimentItemResult
    ],
    errorList: Iterable[zio.aws.comprehend.model.BatchItemError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse = {
    import BatchDetectSentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse
      .builder()
      .resultList(resultList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorList(errorList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly =
    zio.aws.comprehend.model.BatchDetectSentimentResponse.wrap(buildAwsValue())
}
object BatchDetectSentimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectSentimentResponse =
      zio.aws.comprehend.model.BatchDetectSentimentResponse(
        resultList.map { item =>
          item.asEditable
        },
        errorList.map { item =>
          item.asEditable
        }
      )
    def resultList
        : List[zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly]
    def errorList: List[zio.aws.comprehend.model.BatchItemError.ReadOnly]
    def getResultList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly
    ]] = ZIO.succeed(resultList)
    def getErrorList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchItemError.ReadOnly
    ]] = ZIO.succeed(errorList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse
  ) extends zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly {
    override val resultList: List[
      zio.aws.comprehend.model.BatchDetectSentimentItemResult.ReadOnly
    ] = impl
      .resultList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchDetectSentimentItemResult.wrap(item)
      }
      .toList
    override val errorList
        : List[zio.aws.comprehend.model.BatchItemError.ReadOnly] = impl
      .errorList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchItemError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse
  ): zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly =
    new Wrapper(impl)
}
