package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchDetectKeyPhrasesItemResult(
    index: Option[Integer] = None,
    keyPhrases: Option[Iterable[zio.aws.comprehend.model.KeyPhrase]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesItemResult = {
    import BatchDetectKeyPhrasesItemResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesItemResult
      .builder()
      .optionallyWith(
        index.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.index)
      .optionallyWith(
        keyPhrases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyPhrases)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult.ReadOnly =
    zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult
      .wrap(buildAwsValue())
}
object BatchDetectKeyPhrasesItemResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesItemResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult =
      zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult(
        index.map(value => value),
        keyPhrases.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def index: Option[Integer]
    def keyPhrases: Option[List[zio.aws.comprehend.model.KeyPhrase.ReadOnly]]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getKeyPhrases: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.KeyPhrase.ReadOnly
    ]] = AwsError.unwrapOptionField("keyPhrases", keyPhrases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesItemResult
  ) extends zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult.ReadOnly {
    override val index: Option[Integer] = scala
      .Option(impl.index())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val keyPhrases
        : Option[List[zio.aws.comprehend.model.KeyPhrase.ReadOnly]] = scala
      .Option(impl.keyPhrases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.KeyPhrase.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesItemResult
  ): zio.aws.comprehend.model.BatchDetectKeyPhrasesItemResult.ReadOnly =
    new Wrapper(impl)
}
