package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DetectSentimentResponse(
    sentiment: Option[zio.aws.comprehend.model.SentimentType] = None,
    sentimentScore: Option[zio.aws.comprehend.model.SentimentScore] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse = {
    import DetectSentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse
      .builder()
      .optionallyWith(sentiment.map(value => value.unwrap))(_.sentiment)
      .optionallyWith(sentimentScore.map(value => value.buildAwsValue()))(
        _.sentimentScore
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly =
    zio.aws.comprehend.model.DetectSentimentResponse.wrap(buildAwsValue())
}
object DetectSentimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectSentimentResponse =
      zio.aws.comprehend.model.DetectSentimentResponse(
        sentiment.map(value => value),
        sentimentScore.map(value => value.asEditable)
      )
    def sentiment: Option[zio.aws.comprehend.model.SentimentType]
    def sentimentScore: Option[zio.aws.comprehend.model.SentimentScore.ReadOnly]
    def getSentiment
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentType] =
      AwsError.unwrapOptionField("sentiment", sentiment)
    def getSentimentScore
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentScore.ReadOnly] =
      AwsError.unwrapOptionField("sentimentScore", sentimentScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse
  ) extends zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly {
    override val sentiment: Option[zio.aws.comprehend.model.SentimentType] =
      scala
        .Option(impl.sentiment())
        .map(value => zio.aws.comprehend.model.SentimentType.wrap(value))
    override val sentimentScore
        : Option[zio.aws.comprehend.model.SentimentScore.ReadOnly] = scala
      .Option(impl.sentimentScore())
      .map(value => zio.aws.comprehend.model.SentimentScore.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse
  ): zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
