package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: ComprehendArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ComprehendArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.comprehend.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListTagsForResourceRequest =
      zio.aws.comprehend.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ComprehendArn
    def getResourceArn: ZIO[Any, Nothing, ComprehendArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest
  ) extends zio.aws.comprehend.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ComprehendArn =
      zio.aws.comprehend.model.primitives.ComprehendArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest
  ): zio.aws.comprehend.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
