package zio.aws.comprehend.model
import java.lang.Integer
import zio.aws.comprehend.model.primitives.MaxResultsInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDocumentClassifierSummariesRequest(
    nextToken: Option[String] = None,
    maxResults: Option[MaxResultsInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest = {
    import ListDocumentClassifierSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListDocumentClassifierSummariesRequest.ReadOnly =
    zio.aws.comprehend.model.ListDocumentClassifierSummariesRequest
      .wrap(buildAwsValue())
}
object ListDocumentClassifierSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListDocumentClassifierSummariesRequest =
      zio.aws.comprehend.model.ListDocumentClassifierSummariesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[MaxResultsInteger]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest
  ) extends zio.aws.comprehend.model.ListDocumentClassifierSummariesRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest
  ): zio.aws.comprehend.model.ListDocumentClassifierSummariesRequest.ReadOnly =
    new Wrapper(impl)
}
