package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  IamRoleArn,
  AnyLengthString,
  Timestamp,
  EntityRecognizerArn,
  KmsKeyId,
  VersionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EntityRecognizerProperties(
    entityRecognizerArn: Option[EntityRecognizerArn] = None,
    languageCode: Option[zio.aws.comprehend.model.LanguageCode] = None,
    status: Option[zio.aws.comprehend.model.ModelStatus] = None,
    message: Option[AnyLengthString] = None,
    submitTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    trainingStartTime: Option[Timestamp] = None,
    trainingEndTime: Option[Timestamp] = None,
    inputDataConfig: Option[
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig
    ] = None,
    recognizerMetadata: Option[
      zio.aws.comprehend.model.EntityRecognizerMetadata
    ] = None,
    dataAccessRoleArn: Option[IamRoleArn] = None,
    volumeKmsKeyId: Option[KmsKeyId] = None,
    vpcConfig: Option[zio.aws.comprehend.model.VpcConfig] = None,
    modelKmsKeyId: Option[KmsKeyId] = None,
    versionName: Option[VersionName] = None,
    sourceModelArn: Option[EntityRecognizerArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties = {
    import EntityRecognizerProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
      .builder()
      .optionallyWith(
        entityRecognizerArn.map(value =>
          EntityRecognizerArn.unwrap(value): java.lang.String
        )
      )(_.entityRecognizerArn)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        trainingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingStartTime)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(recognizerMetadata.map(value => value.buildAwsValue()))(
        _.recognizerMetadata
      )
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        versionName.map(value => VersionName.unwrap(value): java.lang.String)
      )(_.versionName)
      .optionallyWith(
        sourceModelArn.map(value =>
          EntityRecognizerArn.unwrap(value): java.lang.String
        )
      )(_.sourceModelArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerProperties.wrap(buildAwsValue())
}
object EntityRecognizerProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerProperties =
      zio.aws.comprehend.model.EntityRecognizerProperties(
        entityRecognizerArn.map(value => value),
        languageCode.map(value => value),
        status.map(value => value),
        message.map(value => value),
        submitTime.map(value => value),
        endTime.map(value => value),
        trainingStartTime.map(value => value),
        trainingEndTime.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        recognizerMetadata.map(value => value.asEditable),
        dataAccessRoleArn.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable),
        modelKmsKeyId.map(value => value),
        versionName.map(value => value),
        sourceModelArn.map(value => value)
      )
    def entityRecognizerArn: Option[EntityRecognizerArn]
    def languageCode: Option[zio.aws.comprehend.model.LanguageCode]
    def status: Option[zio.aws.comprehend.model.ModelStatus]
    def message: Option[AnyLengthString]
    def submitTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def trainingStartTime: Option[Timestamp]
    def trainingEndTime: Option[Timestamp]
    def inputDataConfig: Option[
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    ]
    def recognizerMetadata
        : Option[zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly]
    def dataAccessRoleArn: Option[IamRoleArn]
    def volumeKmsKeyId: Option[KmsKeyId]
    def vpcConfig: Option[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def modelKmsKeyId: Option[KmsKeyId]
    def versionName: Option[VersionName]
    def sourceModelArn: Option[EntityRecognizerArn]
    def getEntityRecognizerArn: ZIO[Any, AwsError, EntityRecognizerArn] =
      AwsError.unwrapOptionField("entityRecognizerArn", entityRecognizerArn)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingStartTime", trainingStartTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getRecognizerMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("recognizerMetadata", recognizerMetadata)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getSourceModelArn: ZIO[Any, AwsError, EntityRecognizerArn] =
      AwsError.unwrapOptionField("sourceModelArn", sourceModelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
  ) extends zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly {
    override val entityRecognizerArn: Option[EntityRecognizerArn] = scala
      .Option(impl.entityRecognizerArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.EntityRecognizerArn(value)
      )
    override val languageCode: Option[zio.aws.comprehend.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val status: Option[zio.aws.comprehend.model.ModelStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val message: Option[AnyLengthString] = scala
      .Option(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val submitTime: Option[Timestamp] = scala
      .Option(impl.submitTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingStartTime: Option[Timestamp] = scala
      .Option(impl.trainingStartTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingEndTime: Option[Timestamp] = scala
      .Option(impl.trainingEndTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val inputDataConfig: Option[
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    ] = scala
      .Option(impl.inputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.EntityRecognizerInputDataConfig.wrap(value)
      )
    override val recognizerMetadata
        : Option[zio.aws.comprehend.model.EntityRecognizerMetadata.ReadOnly] =
      scala
        .Option(impl.recognizerMetadata())
        .map(value =>
          zio.aws.comprehend.model.EntityRecognizerMetadata.wrap(value)
        )
    override val dataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val volumeKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Option[zio.aws.comprehend.model.VpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
    override val modelKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.modelKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val versionName: Option[VersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val sourceModelArn: Option[EntityRecognizerArn] = scala
      .Option(impl.sourceModelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.EntityRecognizerArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties
  ): zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly = new Wrapper(
    impl
  )
}
