package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  EntityRecognizerEndpointArn,
  CustomerInputString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DetectEntitiesRequest(
    text: CustomerInputString,
    languageCode: Option[zio.aws.comprehend.model.LanguageCode] = None,
    endpointArn: Option[EntityRecognizerEndpointArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest = {
    import DetectEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
      .builder()
      .text(CustomerInputString.unwrap(text): java.lang.String)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        endpointArn.map(value =>
          EntityRecognizerEndpointArn.unwrap(value): java.lang.String
        )
      )(_.endpointArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectEntitiesRequest.ReadOnly =
    zio.aws.comprehend.model.DetectEntitiesRequest.wrap(buildAwsValue())
}
object DetectEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectEntitiesRequest =
      zio.aws.comprehend.model.DetectEntitiesRequest(
        text,
        languageCode.map(value => value),
        endpointArn.map(value => value)
      )
    def text: CustomerInputString
    def languageCode: Option[zio.aws.comprehend.model.LanguageCode]
    def endpointArn: Option[EntityRecognizerEndpointArn]
    def getText: ZIO[Any, Nothing, CustomerInputString] = ZIO.succeed(text)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getEndpointArn: ZIO[Any, AwsError, EntityRecognizerEndpointArn] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
  ) extends zio.aws.comprehend.model.DetectEntitiesRequest.ReadOnly {
    override val text: CustomerInputString =
      zio.aws.comprehend.model.primitives.CustomerInputString(impl.text())
    override val languageCode: Option[zio.aws.comprehend.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val endpointArn: Option[EntityRecognizerEndpointArn] = scala
      .Option(impl.endpointArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.EntityRecognizerEndpointArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest
  ): zio.aws.comprehend.model.DetectEntitiesRequest.ReadOnly = new Wrapper(impl)
}
