package zio.aws.comprehend.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointStatus {
  def unwrap: software.amazon.awssdk.services.comprehend.model.EndpointStatus
}
object EndpointStatus {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.EndpointStatus
  ): zio.aws.comprehend.model.EndpointStatus = value match {
    case software.amazon.awssdk.services.comprehend.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.EndpointStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.comprehend.model.EndpointStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.comprehend.model.EndpointStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.comprehend.model.EndpointStatus.IN_SERVICE =>
      val r = IN_SERVICE
      r
    case software.amazon.awssdk.services.comprehend.model.EndpointStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EndpointStatus =
      software.amazon.awssdk.services.comprehend.model.EndpointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.comprehend.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EndpointStatus =
      software.amazon.awssdk.services.comprehend.model.EndpointStatus.CREATING
  }
  case object DELETING extends zio.aws.comprehend.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EndpointStatus =
      software.amazon.awssdk.services.comprehend.model.EndpointStatus.DELETING
  }
  case object FAILED extends zio.aws.comprehend.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EndpointStatus =
      software.amazon.awssdk.services.comprehend.model.EndpointStatus.FAILED
  }
  case object IN_SERVICE extends zio.aws.comprehend.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EndpointStatus =
      software.amazon.awssdk.services.comprehend.model.EndpointStatus.IN_SERVICE
  }
  case object UPDATING extends zio.aws.comprehend.model.EndpointStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.EndpointStatus =
      software.amazon.awssdk.services.comprehend.model.EndpointStatus.UPDATING
  }
}
