package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTopicsDetectionJobResponse(
    topicsDetectionJobProperties: Option[
      zio.aws.comprehend.model.TopicsDetectionJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse = {
    import DescribeTopicsDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse
      .builder()
      .optionallyWith(
        topicsDetectionJobProperties.map(value => value.buildAwsValue())
      )(_.topicsDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeTopicsDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse =
      zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse(
        topicsDetectionJobProperties.map(value => value.asEditable)
      )
    def topicsDetectionJobProperties
        : Option[zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly]
    def getTopicsDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "topicsDetectionJobProperties",
      topicsDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly {
    override val topicsDetectionJobProperties: Option[
      zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
    ] = scala
      .Option(impl.topicsDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.TopicsDetectionJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
