package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InputDataConfig(
    s3Uri: S3Uri,
    inputFormat: Option[zio.aws.comprehend.model.InputFormat] = None,
    documentReaderConfig: Option[
      zio.aws.comprehend.model.DocumentReaderConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.InputDataConfig = {
    import InputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.InputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(inputFormat.map(value => value.unwrap))(_.inputFormat)
      .optionallyWith(documentReaderConfig.map(value => value.buildAwsValue()))(
        _.documentReaderConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.InputDataConfig.ReadOnly =
    zio.aws.comprehend.model.InputDataConfig.wrap(buildAwsValue())
}
object InputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.InputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.InputDataConfig =
      zio.aws.comprehend.model.InputDataConfig(
        s3Uri,
        inputFormat.map(value => value),
        documentReaderConfig.map(value => value.asEditable)
      )
    def s3Uri: S3Uri
    def inputFormat: Option[zio.aws.comprehend.model.InputFormat]
    def documentReaderConfig
        : Option[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getInputFormat
        : ZIO[Any, AwsError, zio.aws.comprehend.model.InputFormat] =
      AwsError.unwrapOptionField("inputFormat", inputFormat)
    def getDocumentReaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("documentReaderConfig", documentReaderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.InputDataConfig
  ) extends zio.aws.comprehend.model.InputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val inputFormat: Option[zio.aws.comprehend.model.InputFormat] =
      scala
        .Option(impl.inputFormat())
        .map(value => zio.aws.comprehend.model.InputFormat.wrap(value))
    override val documentReaderConfig
        : Option[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly] = scala
      .Option(impl.documentReaderConfig())
      .map(value => zio.aws.comprehend.model.DocumentReaderConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.InputDataConfig
  ): zio.aws.comprehend.model.InputDataConfig.ReadOnly = new Wrapper(impl)
}
