package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendModelArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportModelResponse(
    modelArn: Option[ComprehendModelArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ImportModelResponse = {
    import ImportModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ImportModelResponse
      .builder()
      .optionallyWith(
        modelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.modelArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ImportModelResponse.ReadOnly =
    zio.aws.comprehend.model.ImportModelResponse.wrap(buildAwsValue())
}
object ImportModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ImportModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ImportModelResponse =
      zio.aws.comprehend.model.ImportModelResponse(modelArn.map(value => value))
    def modelArn: Option[ComprehendModelArn]
    def getModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ImportModelResponse
  ) extends zio.aws.comprehend.model.ImportModelResponse.ReadOnly {
    override val modelArn: Option[ComprehendModelArn] = scala
      .Option(impl.modelArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ImportModelResponse
  ): zio.aws.comprehend.model.ImportModelResponse.ReadOnly = new Wrapper(impl)
}
