package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.PolicyRevisionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyResponse(
    policyRevisionId: Option[PolicyRevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(
        policyRevisionId.map(value =>
          PolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.comprehend.model.PutResourcePolicyResponse.wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.PutResourcePolicyResponse =
      zio.aws.comprehend.model
        .PutResourcePolicyResponse(policyRevisionId.map(value => value))
    def policyRevisionId: Option[PolicyRevisionId]
    def getPolicyRevisionId: ZIO[Any, AwsError, PolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse
  ) extends zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly {
    override val policyRevisionId: Option[PolicyRevisionId] = scala
      .Option(impl.policyRevisionId())
      .map(value => zio.aws.comprehend.model.primitives.PolicyRevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse
  ): zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
