package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchDetectEntitiesResponse(
    resultList: Iterable[
      zio.aws.comprehend.model.BatchDetectEntitiesItemResult
    ],
    errorList: Iterable[zio.aws.comprehend.model.BatchItemError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse = {
    import BatchDetectEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse
      .builder()
      .resultList(resultList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorList(errorList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly =
    zio.aws.comprehend.model.BatchDetectEntitiesResponse.wrap(buildAwsValue())
}
object BatchDetectEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectEntitiesResponse =
      zio.aws.comprehend.model.BatchDetectEntitiesResponse(
        resultList.map { item =>
          item.asEditable
        },
        errorList.map { item =>
          item.asEditable
        }
      )
    def resultList
        : List[zio.aws.comprehend.model.BatchDetectEntitiesItemResult.ReadOnly]
    def errorList: List[zio.aws.comprehend.model.BatchItemError.ReadOnly]
    def getResultList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchDetectEntitiesItemResult.ReadOnly
    ]] = ZIO.succeed(resultList)
    def getErrorList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchItemError.ReadOnly
    ]] = ZIO.succeed(errorList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse
  ) extends zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly {
    override val resultList: List[
      zio.aws.comprehend.model.BatchDetectEntitiesItemResult.ReadOnly
    ] = impl
      .resultList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchDetectEntitiesItemResult.wrap(item)
      }
      .toList
    override val errorList
        : List[zio.aws.comprehend.model.BatchItemError.ReadOnly] = impl
      .errorList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchItemError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse
  ): zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly =
    new Wrapper(impl)
}
