package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DetectPiiEntitiesResponse(
    entities: Option[Iterable[zio.aws.comprehend.model.PiiEntity]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse = {
    import DetectPiiEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse
      .builder()
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly =
    zio.aws.comprehend.model.DetectPiiEntitiesResponse.wrap(buildAwsValue())
}
object DetectPiiEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DetectPiiEntitiesResponse =
      zio.aws.comprehend.model.DetectPiiEntitiesResponse(
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entities: Option[List[zio.aws.comprehend.model.PiiEntity.ReadOnly]]
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.PiiEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse
  ) extends zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly {
    override val entities
        : Option[List[zio.aws.comprehend.model.PiiEntity.ReadOnly]] = scala
      .Option(impl.entities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.PiiEntity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse
  ): zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
