package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{KmsKeyId, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DocumentClassifierOutputDataConfig(
    s3Uri: Option[S3Uri] = None,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierOutputDataConfig = {
    import DocumentClassifierOutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierOutputDataConfig
      .builder()
      .optionallyWith(
        s3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3Uri)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierOutputDataConfig
      .wrap(buildAwsValue())
}
object DocumentClassifierOutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierOutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DocumentClassifierOutputDataConfig =
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig(
        s3Uri.map(value => value),
        kmsKeyId.map(value => value)
      )
    def s3Uri: Option[S3Uri]
    def kmsKeyId: Option[KmsKeyId]
    def getS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierOutputDataConfig
  ) extends zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly {
    override val s3Uri: Option[S3Uri] = scala
      .Option(impl.s3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierOutputDataConfig
  ): zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly =
    new Wrapper(impl)
}
