package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointResponse(
    endpointProperties: Option[zio.aws.comprehend.model.EndpointProperties] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse = {
    import DescribeEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse
      .builder()
      .optionallyWith(endpointProperties.map(value => value.buildAwsValue()))(
        _.endpointProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeEndpointResponse.wrap(buildAwsValue())
}
object DescribeEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeEndpointResponse =
      zio.aws.comprehend.model.DescribeEndpointResponse(
        endpointProperties.map(value => value.asEditable)
      )
    def endpointProperties
        : Option[zio.aws.comprehend.model.EndpointProperties.ReadOnly]
    def getEndpointProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EndpointProperties.ReadOnly
    ] = AwsError.unwrapOptionField("endpointProperties", endpointProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse
  ) extends zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly {
    override val endpointProperties
        : Option[zio.aws.comprehend.model.EndpointProperties.ReadOnly] = scala
      .Option(impl.endpointProperties())
      .map(value => zio.aws.comprehend.model.EndpointProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse
  ): zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
