package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{AttributeNamesListItem, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AugmentedManifestsListItem(
    s3Uri: S3Uri,
    split: Option[zio.aws.comprehend.model.Split] = None,
    attributeNames: Iterable[AttributeNamesListItem],
    annotationDataS3Uri: Option[S3Uri] = None,
    sourceDocumentsS3Uri: Option[S3Uri] = None,
    documentType: Option[
      zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.AugmentedManifestsListItem = {
    import AugmentedManifestsListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.AugmentedManifestsListItem
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(split.map(value => value.unwrap))(_.split)
      .attributeNames(attributeNames.map { item =>
        AttributeNamesListItem.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        annotationDataS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.annotationDataS3Uri)
      .optionallyWith(
        sourceDocumentsS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.sourceDocumentsS3Uri)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly =
    zio.aws.comprehend.model.AugmentedManifestsListItem.wrap(buildAwsValue())
}
object AugmentedManifestsListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.AugmentedManifestsListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.AugmentedManifestsListItem =
      zio.aws.comprehend.model.AugmentedManifestsListItem(
        s3Uri,
        split.map(value => value),
        attributeNames,
        annotationDataS3Uri.map(value => value),
        sourceDocumentsS3Uri.map(value => value),
        documentType.map(value => value)
      )
    def s3Uri: S3Uri
    def split: Option[zio.aws.comprehend.model.Split]
    def attributeNames: List[AttributeNamesListItem]
    def annotationDataS3Uri: Option[S3Uri]
    def sourceDocumentsS3Uri: Option[S3Uri]
    def documentType
        : Option[zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getSplit: ZIO[Any, AwsError, zio.aws.comprehend.model.Split] =
      AwsError.unwrapOptionField("split", split)
    def getAttributeNames: ZIO[Any, Nothing, List[AttributeNamesListItem]] =
      ZIO.succeed(attributeNames)
    def getAnnotationDataS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("annotationDataS3Uri", annotationDataS3Uri)
    def getSourceDocumentsS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("sourceDocumentsS3Uri", sourceDocumentsS3Uri)
    def getDocumentType: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
    ] = AwsError.unwrapOptionField("documentType", documentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.AugmentedManifestsListItem
  ) extends zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val split: Option[zio.aws.comprehend.model.Split] = scala
      .Option(impl.split())
      .map(value => zio.aws.comprehend.model.Split.wrap(value))
    override val attributeNames: List[AttributeNamesListItem] = impl
      .attributeNames()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.AttributeNamesListItem(item)
      }
      .toList
    override val annotationDataS3Uri: Option[S3Uri] = scala
      .Option(impl.annotationDataS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val sourceDocumentsS3Uri: Option[S3Uri] = scala
      .Option(impl.sourceDocumentsS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val documentType: Option[
      zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
    ] = scala
      .Option(impl.documentType())
      .map(value =>
        zio.aws.comprehend.model.AugmentedManifestsDocumentTypeFormat
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.AugmentedManifestsListItem
  ): zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly = new Wrapper(
    impl
  )
}
