package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{LabelDelimiter, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DocumentClassifierInputDataConfig(
    dataFormat: Option[zio.aws.comprehend.model.DocumentClassifierDataFormat] =
      None,
    s3Uri: Option[S3Uri] = None,
    testS3Uri: Option[S3Uri] = None,
    labelDelimiter: Option[LabelDelimiter] = None,
    augmentedManifests: Option[
      Iterable[zio.aws.comprehend.model.AugmentedManifestsListItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig = {
    import DocumentClassifierInputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
      .builder()
      .optionallyWith(dataFormat.map(value => value.unwrap))(_.dataFormat)
      .optionallyWith(
        s3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3Uri)
      .optionallyWith(
        testS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.testS3Uri)
      .optionallyWith(
        labelDelimiter.map(value =>
          LabelDelimiter.unwrap(value): java.lang.String
        )
      )(_.labelDelimiter)
      .optionallyWith(
        augmentedManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.augmentedManifests)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierInputDataConfig
      .wrap(buildAwsValue())
}
object DocumentClassifierInputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierInputDataConfig =
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig(
        dataFormat.map(value => value),
        s3Uri.map(value => value),
        testS3Uri.map(value => value),
        labelDelimiter.map(value => value),
        augmentedManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dataFormat
        : Option[zio.aws.comprehend.model.DocumentClassifierDataFormat]
    def s3Uri: Option[S3Uri]
    def testS3Uri: Option[S3Uri]
    def labelDelimiter: Option[LabelDelimiter]
    def augmentedManifests: Option[
      List[zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly]
    ]
    def getDataFormat: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierDataFormat
    ] = AwsError.unwrapOptionField("dataFormat", dataFormat)
    def getS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
    def getTestS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("testS3Uri", testS3Uri)
    def getLabelDelimiter: ZIO[Any, AwsError, LabelDelimiter] =
      AwsError.unwrapOptionField("labelDelimiter", labelDelimiter)
    def getAugmentedManifests: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("augmentedManifests", augmentedManifests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
  ) extends zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly {
    override val dataFormat
        : Option[zio.aws.comprehend.model.DocumentClassifierDataFormat] = scala
      .Option(impl.dataFormat())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierDataFormat.wrap(value)
      )
    override val s3Uri: Option[S3Uri] = scala
      .Option(impl.s3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val testS3Uri: Option[S3Uri] = scala
      .Option(impl.testS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val labelDelimiter: Option[LabelDelimiter] = scala
      .Option(impl.labelDelimiter())
      .map(value => zio.aws.comprehend.model.primitives.LabelDelimiter(value))
    override val augmentedManifests: Option[
      List[zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly]
    ] = scala
      .Option(impl.augmentedManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.AugmentedManifestsListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
  ): zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly =
    new Wrapper(impl)
}
