package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class KeyPhrase(
    score: Option[Float] = None,
    text: Option[String] = None,
    beginOffset: Option[Integer] = None,
    endOffset: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.KeyPhrase = {
    import KeyPhrase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.KeyPhrase
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(
        beginOffset.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.beginOffset)
      .optionallyWith(
        endOffset.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.endOffset)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.KeyPhrase.ReadOnly =
    zio.aws.comprehend.model.KeyPhrase.wrap(buildAwsValue())
}
object KeyPhrase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.KeyPhrase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.KeyPhrase =
      zio.aws.comprehend.model.KeyPhrase(
        score.map(value => value),
        text.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def score: Option[Float]
    def text: Option[String]
    def beginOffset: Option[Integer]
    def endOffset: Option[Integer]
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.KeyPhrase
  ) extends zio.aws.comprehend.model.KeyPhrase.ReadOnly {
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
    override val text: Option[String] =
      scala.Option(impl.text()).map(value => value: String)
    override val beginOffset: Option[Integer] = scala
      .Option(impl.beginOffset())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val endOffset: Option[Integer] = scala
      .Option(impl.endOffset())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.KeyPhrase
  ): zio.aws.comprehend.model.KeyPhrase.ReadOnly = new Wrapper(impl)
}
