package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.DocumentClassifierArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDocumentClassifierResponse(
    documentClassifierArn: Option[DocumentClassifierArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse = {
    import CreateDocumentClassifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse
      .builder()
      .optionallyWith(
        documentClassifierArn.map(value =>
          DocumentClassifierArn.unwrap(value): java.lang.String
        )
      )(_.documentClassifierArn)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly =
    zio.aws.comprehend.model.CreateDocumentClassifierResponse
      .wrap(buildAwsValue())
}
object CreateDocumentClassifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateDocumentClassifierResponse =
      zio.aws.comprehend.model.CreateDocumentClassifierResponse(
        documentClassifierArn.map(value => value)
      )
    def documentClassifierArn: Option[DocumentClassifierArn]
    def getDocumentClassifierArn: ZIO[Any, AwsError, DocumentClassifierArn] =
      AwsError.unwrapOptionField("documentClassifierArn", documentClassifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse
  ) extends zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly {
    override val documentClassifierArn: Option[DocumentClassifierArn] = scala
      .Option(impl.documentClassifierArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.DocumentClassifierArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse
  ): zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly =
    new Wrapper(impl)
}
