package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchDetectDominantLanguageItemResult(
    index: Option[Integer] = None,
    languages: Option[Iterable[zio.aws.comprehend.model.DominantLanguage]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult = {
    import BatchDetectDominantLanguageItemResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
      .builder()
      .optionallyWith(
        index.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.index)
      .optionallyWith(
        languages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.languages)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly =
    zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult
      .wrap(buildAwsValue())
}
object BatchDetectDominantLanguageItemResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult =
      zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult(
        index.map(value => value),
        languages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def index: Option[Integer]
    def languages
        : Option[List[zio.aws.comprehend.model.DominantLanguage.ReadOnly]]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getLanguages: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DominantLanguage.ReadOnly
    ]] = AwsError.unwrapOptionField("languages", languages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
  ) extends zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly {
    override val index: Option[Integer] = scala
      .Option(impl.index())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val languages
        : Option[List[zio.aws.comprehend.model.DominantLanguage.ReadOnly]] =
      scala
        .Option(impl.languages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.DominantLanguage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult
  ): zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly =
    new Wrapper(impl)
}
