package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEventsDetectionJobsResponse(
    eventsDetectionJobPropertiesList: Option[
      Iterable[zio.aws.comprehend.model.EventsDetectionJobProperties]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse = {
    import ListEventsDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse
      .builder()
      .optionallyWith(
        eventsDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventsDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListEventsDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListEventsDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListEventsDetectionJobsResponse =
      zio.aws.comprehend.model.ListEventsDetectionJobsResponse(
        eventsDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventsDetectionJobPropertiesList: Option[
      List[zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly]
    ]
    def nextToken: Option[String]
    def getEventsDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventsDetectionJobPropertiesList",
      eventsDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly {
    override val eventsDetectionJobPropertiesList: Option[
      List[zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly]
    ] = scala
      .Option(impl.eventsDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.EventsDetectionJobProperties.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse
  ): zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
