package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopPiiEntitiesDetectionJobResponse(
    jobId: Option[JobId] = None,
    jobStatus: Option[zio.aws.comprehend.model.JobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse = {
    import StopPiiEntitiesDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse
      .wrap(buildAwsValue())
}
object StopPiiEntitiesDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse =
      zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse(
        jobId.map(value => value),
        jobStatus.map(value => value)
      )
    def jobId: Option[JobId]
    def jobStatus: Option[zio.aws.comprehend.model.JobStatus]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse
  ) extends zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobStatus: Option[zio.aws.comprehend.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse
  ): zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
