package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{ComprehendArn, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartEntitiesDetectionJobResponse(
    jobId: Option[JobId] = None,
    jobArn: Option[ComprehendArn] = None,
    jobStatus: Option[zio.aws.comprehend.model.JobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse = {
    import StartEntitiesDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.StartEntitiesDetectionJobResponse
      .wrap(buildAwsValue())
}
object StartEntitiesDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StartEntitiesDetectionJobResponse =
      zio.aws.comprehend.model.StartEntitiesDetectionJobResponse(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobStatus.map(value => value)
      )
    def jobId: Option[JobId]
    def jobArn: Option[ComprehendArn]
    def jobStatus: Option[zio.aws.comprehend.model.JobStatus]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
  ) extends zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Option[ComprehendArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobStatus: Option[zio.aws.comprehend.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse
  ): zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
