package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDocumentClassifiersResponse(
    documentClassifierPropertiesList: Option[
      Iterable[zio.aws.comprehend.model.DocumentClassifierProperties]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse = {
    import ListDocumentClassifiersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
      .builder()
      .optionallyWith(
        documentClassifierPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentClassifierPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly =
    zio.aws.comprehend.model.ListDocumentClassifiersResponse
      .wrap(buildAwsValue())
}
object ListDocumentClassifiersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListDocumentClassifiersResponse =
      zio.aws.comprehend.model.ListDocumentClassifiersResponse(
        documentClassifierPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def documentClassifierPropertiesList: Option[
      List[zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly]
    ]
    def nextToken: Option[String]
    def getDocumentClassifierPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentClassifierPropertiesList",
      documentClassifierPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
  ) extends zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly {
    override val documentClassifierPropertiesList: Option[
      List[zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly]
    ] = scala
      .Option(impl.documentClassifierPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentClassifierProperties.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse
  ): zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly =
    new Wrapper(impl)
}
