package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEntitiesDetectionJobResponse(
    entitiesDetectionJobProperties: Option[
      zio.aws.comprehend.model.EntitiesDetectionJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse = {
    import DescribeEntitiesDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
      .builder()
      .optionallyWith(
        entitiesDetectionJobProperties.map(value => value.buildAwsValue())
      )(_.entitiesDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeEntitiesDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse =
      zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse(
        entitiesDetectionJobProperties.map(value => value.asEditable)
      )
    def entitiesDetectionJobProperties: Option[
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ]
    def getEntitiesDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "entitiesDetectionJobProperties",
      entitiesDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly {
    override val entitiesDetectionJobProperties: Option[
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ] = scala
      .Option(impl.entitiesDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.EntitiesDetectionJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
