package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentClassifierResponse(
    documentClassifierProperties: Option[
      zio.aws.comprehend.model.DocumentClassifierProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse = {
    import DescribeDocumentClassifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse
      .builder()
      .optionallyWith(
        documentClassifierProperties.map(value => value.buildAwsValue())
      )(_.documentClassifierProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeDocumentClassifierResponse
      .wrap(buildAwsValue())
}
object DescribeDocumentClassifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeDocumentClassifierResponse =
      zio.aws.comprehend.model.DescribeDocumentClassifierResponse(
        documentClassifierProperties.map(value => value.asEditable)
      )
    def documentClassifierProperties
        : Option[zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly]
    def getDocumentClassifierProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentClassifierProperties",
      documentClassifierProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse
  ) extends zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly {
    override val documentClassifierProperties: Option[
      zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
    ] = scala
      .Option(impl.documentClassifierProperties())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse
  ): zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly =
    new Wrapper(impl)
}
