package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PartOfSpeechTag(
    tag: Option[zio.aws.comprehend.model.PartOfSpeechTagType] = None,
    score: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag = {
    import PartOfSpeechTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
      .builder()
      .optionallyWith(tag.map(value => value.unwrap))(_.tag)
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly =
    zio.aws.comprehend.model.PartOfSpeechTag.wrap(buildAwsValue())
}
object PartOfSpeechTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.PartOfSpeechTag =
      zio.aws.comprehend.model
        .PartOfSpeechTag(tag.map(value => value), score.map(value => value))
    def tag: Option[zio.aws.comprehend.model.PartOfSpeechTagType]
    def score: Option[Float]
    def getTag
        : ZIO[Any, AwsError, zio.aws.comprehend.model.PartOfSpeechTagType] =
      AwsError.unwrapOptionField("tag", tag)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
  ) extends zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly {
    override val tag: Option[zio.aws.comprehend.model.PartOfSpeechTagType] =
      scala
        .Option(impl.tag())
        .map(value => zio.aws.comprehend.model.PartOfSpeechTagType.wrap(value))
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
  ): zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly = new Wrapper(impl)
}
