package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  DocumentClassifierArn,
  ComprehendArn,
  JobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartDocumentClassificationJobResponse(
    jobId: Optional[JobId] = Optional.Absent,
    jobArn: Optional[ComprehendArn] = Optional.Absent,
    jobStatus: Optional[zio.aws.comprehend.model.JobStatus] = Optional.Absent,
    documentClassifierArn: Optional[DocumentClassifierArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse = {
    import StartDocumentClassificationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        documentClassifierArn.map(value =>
          DocumentClassifierArn.unwrap(value): java.lang.String
        )
      )(_.documentClassifierArn)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly =
    zio.aws.comprehend.model.StartDocumentClassificationJobResponse
      .wrap(buildAwsValue())
}
object StartDocumentClassificationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StartDocumentClassificationJobResponse =
      zio.aws.comprehend.model.StartDocumentClassificationJobResponse(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobStatus.map(value => value),
        documentClassifierArn.map(value => value)
      )
    def jobId: Optional[JobId]
    def jobArn: Optional[ComprehendArn]
    def jobStatus: Optional[zio.aws.comprehend.model.JobStatus]
    def documentClassifierArn: Optional[DocumentClassifierArn]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getDocumentClassifierArn: ZIO[Any, AwsError, DocumentClassifierArn] =
      AwsError.unwrapOptionField("documentClassifierArn", documentClassifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse
  ) extends zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Optional[ComprehendArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobStatus: Optional[zio.aws.comprehend.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
    override val documentClassifierArn: Optional[DocumentClassifierArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentClassifierArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.DocumentClassifierArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse
  ): zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly =
    new Wrapper(impl)
}
