package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PartOfSpeechTag(
    tag: Optional[zio.aws.comprehend.model.PartOfSpeechTagType] =
      Optional.Absent,
    score: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag = {
    import PartOfSpeechTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
      .builder()
      .optionallyWith(tag.map(value => value.unwrap))(_.tag)
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly =
    zio.aws.comprehend.model.PartOfSpeechTag.wrap(buildAwsValue())
}
object PartOfSpeechTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.PartOfSpeechTag =
      zio.aws.comprehend.model
        .PartOfSpeechTag(tag.map(value => value), score.map(value => value))
    def tag: Optional[zio.aws.comprehend.model.PartOfSpeechTagType]
    def score: Optional[Float]
    def getTag
        : ZIO[Any, AwsError, zio.aws.comprehend.model.PartOfSpeechTagType] =
      AwsError.unwrapOptionField("tag", tag)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
  ) extends zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly {
    override val tag: Optional[zio.aws.comprehend.model.PartOfSpeechTagType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tag())
        .map(value => zio.aws.comprehend.model.PartOfSpeechTagType.wrap(value))
    override val score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag
  ): zio.aws.comprehend.model.PartOfSpeechTag.ReadOnly = new Wrapper(impl)
}
