package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  ComprehendFlywheelArn,
  ComprehendModelArn,
  AnyLengthString,
  S3Uri,
  Timestamp,
  FlywheelIterationId
}
import scala.jdk.CollectionConverters._
final case class FlywheelIterationProperties(
    flywheelArn: Optional[ComprehendFlywheelArn] = Optional.Absent,
    flywheelIterationId: Optional[FlywheelIterationId] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.comprehend.model.FlywheelIterationStatus] =
      Optional.Absent,
    message: Optional[AnyLengthString] = Optional.Absent,
    evaluatedModelArn: Optional[ComprehendModelArn] = Optional.Absent,
    evaluatedModelMetrics: Optional[
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics
    ] = Optional.Absent,
    trainedModelArn: Optional[ComprehendModelArn] = Optional.Absent,
    trainedModelMetrics: Optional[
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics
    ] = Optional.Absent,
    evaluationManifestS3Prefix: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties = {
    import FlywheelIterationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties
      .builder()
      .optionallyWith(
        flywheelArn.map(value =>
          ComprehendFlywheelArn.unwrap(value): java.lang.String
        )
      )(_.flywheelArn)
      .optionallyWith(
        flywheelIterationId.map(value =>
          FlywheelIterationId.unwrap(value): java.lang.String
        )
      )(_.flywheelIterationId)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        evaluatedModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.evaluatedModelArn)
      .optionallyWith(
        evaluatedModelMetrics.map(value => value.buildAwsValue())
      )(_.evaluatedModelMetrics)
      .optionallyWith(
        trainedModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.trainedModelArn)
      .optionallyWith(trainedModelMetrics.map(value => value.buildAwsValue()))(
        _.trainedModelMetrics
      )
      .optionallyWith(
        evaluationManifestS3Prefix.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.evaluationManifestS3Prefix)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly =
    zio.aws.comprehend.model.FlywheelIterationProperties.wrap(buildAwsValue())
}
object FlywheelIterationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.FlywheelIterationProperties =
      zio.aws.comprehend.model.FlywheelIterationProperties(
        flywheelArn.map(value => value),
        flywheelIterationId.map(value => value),
        creationTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value),
        message.map(value => value),
        evaluatedModelArn.map(value => value),
        evaluatedModelMetrics.map(value => value.asEditable),
        trainedModelArn.map(value => value),
        trainedModelMetrics.map(value => value.asEditable),
        evaluationManifestS3Prefix.map(value => value)
      )
    def flywheelArn: Optional[ComprehendFlywheelArn]
    def flywheelIterationId: Optional[FlywheelIterationId]
    def creationTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def status: Optional[zio.aws.comprehend.model.FlywheelIterationStatus]
    def message: Optional[AnyLengthString]
    def evaluatedModelArn: Optional[ComprehendModelArn]
    def evaluatedModelMetrics: Optional[
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly
    ]
    def trainedModelArn: Optional[ComprehendModelArn]
    def trainedModelMetrics: Optional[
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly
    ]
    def evaluationManifestS3Prefix: Optional[S3Uri]
    def getFlywheelArn: ZIO[Any, AwsError, ComprehendFlywheelArn] =
      AwsError.unwrapOptionField("flywheelArn", flywheelArn)
    def getFlywheelIterationId: ZIO[Any, AwsError, FlywheelIterationId] =
      AwsError.unwrapOptionField("flywheelIterationId", flywheelIterationId)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.comprehend.model.FlywheelIterationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getEvaluatedModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("evaluatedModelArn", evaluatedModelArn)
    def getEvaluatedModelMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly
    ] =
      AwsError.unwrapOptionField("evaluatedModelMetrics", evaluatedModelMetrics)
    def getTrainedModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("trainedModelArn", trainedModelArn)
    def getTrainedModelMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("trainedModelMetrics", trainedModelMetrics)
    def getEvaluationManifestS3Prefix: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField(
        "evaluationManifestS3Prefix",
        evaluationManifestS3Prefix
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties
  ) extends zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly {
    override val flywheelArn: Optional[ComprehendFlywheelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendFlywheelArn(value)
        )
    override val flywheelIterationId: Optional[FlywheelIterationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelIterationId())
        .map(value =>
          zio.aws.comprehend.model.primitives.FlywheelIterationId(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.comprehend.model.FlywheelIterationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.comprehend.model.FlywheelIterationStatus.wrap(value)
        )
    override val message: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val evaluatedModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluatedModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
    override val evaluatedModelMetrics: Optional[
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluatedModelMetrics())
      .map(value =>
        zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.wrap(value)
      )
    override val trainedModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainedModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
    override val trainedModelMetrics: Optional[
      zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainedModelMetrics())
      .map(value =>
        zio.aws.comprehend.model.FlywheelModelEvaluationMetrics.wrap(value)
      )
    override val evaluationManifestS3Prefix: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationManifestS3Prefix())
        .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.FlywheelIterationProperties
  ): zio.aws.comprehend.model.FlywheelIterationProperties.ReadOnly =
    new Wrapper(impl)
}
