package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendFlywheelArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeFlywheelRequest(flywheelArn: ComprehendFlywheelArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest = {
    import DescribeFlywheelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest
      .builder()
      .flywheelArn(ComprehendFlywheelArn.unwrap(flywheelArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DescribeFlywheelRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeFlywheelRequest.wrap(buildAwsValue())
}
object DescribeFlywheelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeFlywheelRequest =
      zio.aws.comprehend.model.DescribeFlywheelRequest(flywheelArn)
    def flywheelArn: ComprehendFlywheelArn
    def getFlywheelArn: ZIO[Any, Nothing, ComprehendFlywheelArn] =
      ZIO.succeed(flywheelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest
  ) extends zio.aws.comprehend.model.DescribeFlywheelRequest.ReadOnly {
    override val flywheelArn: ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendFlywheelArn(impl.flywheelArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest
  ): zio.aws.comprehend.model.DescribeFlywheelRequest.ReadOnly = new Wrapper(
    impl
  )
}
