package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait DatasetDataFormat {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DatasetDataFormat
}
object DatasetDataFormat {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DatasetDataFormat
  ): zio.aws.comprehend.model.DatasetDataFormat = value match {
    case software.amazon.awssdk.services.comprehend.model.DatasetDataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DatasetDataFormat.COMPREHEND_CSV =>
      val r = COMPREHEND_CSV
      r
    case software.amazon.awssdk.services.comprehend.model.DatasetDataFormat.AUGMENTED_MANIFEST =>
      val r = AUGMENTED_MANIFEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DatasetDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetDataFormat =
      software.amazon.awssdk.services.comprehend.model.DatasetDataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPREHEND_CSV
      extends zio.aws.comprehend.model.DatasetDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetDataFormat =
      software.amazon.awssdk.services.comprehend.model.DatasetDataFormat.COMPREHEND_CSV
  }
  case object AUGMENTED_MANIFEST
      extends zio.aws.comprehend.model.DatasetDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DatasetDataFormat =
      software.amazon.awssdk.services.comprehend.model.DatasetDataFormat.AUGMENTED_MANIFEST
  }
}
