package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFlywheelsResponse(
    flywheelSummaryList: Optional[
      Iterable[zio.aws.comprehend.model.FlywheelSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse = {
    import ListFlywheelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse
      .builder()
      .optionallyWith(
        flywheelSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.flywheelSummaryList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ListFlywheelsResponse.ReadOnly =
    zio.aws.comprehend.model.ListFlywheelsResponse.wrap(buildAwsValue())
}
object ListFlywheelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListFlywheelsResponse =
      zio.aws.comprehend.model.ListFlywheelsResponse(
        flywheelSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def flywheelSummaryList
        : Optional[List[zio.aws.comprehend.model.FlywheelSummary.ReadOnly]]
    def nextToken: Optional[String]
    def getFlywheelSummaryList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.FlywheelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("flywheelSummaryList", flywheelSummaryList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse
  ) extends zio.aws.comprehend.model.ListFlywheelsResponse.ReadOnly {
    override val flywheelSummaryList
        : Optional[List[zio.aws.comprehend.model.FlywheelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.FlywheelSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse
  ): zio.aws.comprehend.model.ListFlywheelsResponse.ReadOnly = new Wrapper(impl)
}
