package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDatasetsResponse(
    datasetPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.DatasetProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse
      .builder()
      .optionallyWith(
        datasetPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ListDatasetsResponse.ReadOnly =
    zio.aws.comprehend.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListDatasetsResponse =
      zio.aws.comprehend.model.ListDatasetsResponse(
        datasetPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetPropertiesList
        : Optional[List[zio.aws.comprehend.model.DatasetProperties.ReadOnly]]
    def nextToken: Optional[String]
    def getDatasetPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DatasetProperties.ReadOnly
    ]] =
      AwsError.unwrapOptionField("datasetPropertiesList", datasetPropertiesList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse
  ) extends zio.aws.comprehend.model.ListDatasetsResponse.ReadOnly {
    override val datasetPropertiesList
        : Optional[List[zio.aws.comprehend.model.DatasetProperties.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetPropertiesList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.DatasetProperties.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse
  ): zio.aws.comprehend.model.ListDatasetsResponse.ReadOnly = new Wrapper(impl)
}
