package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait FlywheelStatus {
  def unwrap: software.amazon.awssdk.services.comprehend.model.FlywheelStatus
}
object FlywheelStatus {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.FlywheelStatus
  ): zio.aws.comprehend.model.FlywheelStatus = value match {
    case software.amazon.awssdk.services.comprehend.model.FlywheelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.FlywheelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.comprehend.model.FlywheelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelStatus.CREATING
  }
  case object ACTIVE extends zio.aws.comprehend.model.FlywheelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.comprehend.model.FlywheelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelStatus.UPDATING
  }
  case object DELETING extends zio.aws.comprehend.model.FlywheelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelStatus.DELETING
  }
  case object FAILED extends zio.aws.comprehend.model.FlywheelStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelStatus.FAILED
  }
}
