package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class DatasetFilter(
    status: Optional[zio.aws.comprehend.model.DatasetStatus] = Optional.Absent,
    datasetType: Optional[zio.aws.comprehend.model.DatasetType] =
      Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetFilter = {
    import DatasetFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(datasetType.map(value => value.unwrap))(_.datasetType)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DatasetFilter.ReadOnly =
    zio.aws.comprehend.model.DatasetFilter.wrap(buildAwsValue())
}
object DatasetFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DatasetFilter =
      zio.aws.comprehend.model.DatasetFilter(
        status.map(value => value),
        datasetType.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value)
      )
    def status: Optional[zio.aws.comprehend.model.DatasetStatus]
    def datasetType: Optional[zio.aws.comprehend.model.DatasetType]
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDatasetType
        : ZIO[Any, AwsError, zio.aws.comprehend.model.DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetFilter
  ) extends zio.aws.comprehend.model.DatasetFilter.ReadOnly {
    override val status: Optional[zio.aws.comprehend.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.DatasetStatus.wrap(value))
    override val datasetType: Optional[zio.aws.comprehend.model.DatasetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetType())
        .map(value => zio.aws.comprehend.model.DatasetType.wrap(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetFilter
  ): zio.aws.comprehend.model.DatasetFilter.ReadOnly = new Wrapper(impl)
}
