package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  IamRoleArn,
  AnyLengthString,
  Timestamp,
  EventTypeString,
  JobName,
  JobId,
  ComprehendArn
}
import scala.jdk.CollectionConverters._
final case class EventsDetectionJobProperties(
    jobId: Optional[JobId] = Optional.Absent,
    jobArn: Optional[ComprehendArn] = Optional.Absent,
    jobName: Optional[JobName] = Optional.Absent,
    jobStatus: Optional[zio.aws.comprehend.model.JobStatus] = Optional.Absent,
    message: Optional[AnyLengthString] = Optional.Absent,
    submitTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    inputDataConfig: Optional[zio.aws.comprehend.model.InputDataConfig] =
      Optional.Absent,
    outputDataConfig: Optional[zio.aws.comprehend.model.OutputDataConfig] =
      Optional.Absent,
    languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    targetEventTypes: Optional[Iterable[EventTypeString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties = {
    import EventsDetectionJobProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        targetEventTypes.map(value =>
          value.map { item =>
            EventTypeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetEventTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly =
    zio.aws.comprehend.model.EventsDetectionJobProperties.wrap(buildAwsValue())
}
object EventsDetectionJobProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EventsDetectionJobProperties =
      zio.aws.comprehend.model.EventsDetectionJobProperties(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobName.map(value => value),
        jobStatus.map(value => value),
        message.map(value => value),
        submitTime.map(value => value),
        endTime.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        outputDataConfig.map(value => value.asEditable),
        languageCode.map(value => value),
        dataAccessRoleArn.map(value => value),
        targetEventTypes.map(value => value)
      )
    def jobId: Optional[JobId]
    def jobArn: Optional[ComprehendArn]
    def jobName: Optional[JobName]
    def jobStatus: Optional[zio.aws.comprehend.model.JobStatus]
    def message: Optional[AnyLengthString]
    def submitTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def inputDataConfig
        : Optional[zio.aws.comprehend.model.InputDataConfig.ReadOnly]
    def outputDataConfig
        : Optional[zio.aws.comprehend.model.OutputDataConfig.ReadOnly]
    def languageCode: Optional[zio.aws.comprehend.model.LanguageCode]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def targetEventTypes: Optional[List[EventTypeString]]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.InputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getTargetEventTypes: ZIO[Any, AwsError, List[EventTypeString]] =
      AwsError.unwrapOptionField("targetEventTypes", targetEventTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
  ) extends zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Optional[ComprehendArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val jobStatus: Optional[zio.aws.comprehend.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
    override val message: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val submitTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val inputDataConfig
        : Optional[zio.aws.comprehend.model.InputDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputDataConfig())
        .map(value => zio.aws.comprehend.model.InputDataConfig.wrap(value))
    override val outputDataConfig
        : Optional[zio.aws.comprehend.model.OutputDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputDataConfig())
        .map(value => zio.aws.comprehend.model.OutputDataConfig.wrap(value))
    override val languageCode: Optional[zio.aws.comprehend.model.LanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val targetEventTypes: Optional[List[EventTypeString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetEventTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.primitives.EventTypeString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties
  ): zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly =
    new Wrapper(impl)
}
