package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{LabelDelimiter, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentClassifierInputDataConfig(
    dataFormat: Optional[
      zio.aws.comprehend.model.DocumentClassifierDataFormat
    ] = Optional.Absent,
    s3Uri: Optional[S3Uri] = Optional.Absent,
    testS3Uri: Optional[S3Uri] = Optional.Absent,
    labelDelimiter: Optional[LabelDelimiter] = Optional.Absent,
    augmentedManifests: Optional[
      Iterable[zio.aws.comprehend.model.AugmentedManifestsListItem]
    ] = Optional.Absent,
    documentType: Optional[
      zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat
    ] = Optional.Absent,
    documents: Optional[zio.aws.comprehend.model.DocumentClassifierDocuments] =
      Optional.Absent,
    documentReaderConfig: Optional[
      zio.aws.comprehend.model.DocumentReaderConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig = {
    import DocumentClassifierInputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
      .builder()
      .optionallyWith(dataFormat.map(value => value.unwrap))(_.dataFormat)
      .optionallyWith(
        s3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3Uri)
      .optionallyWith(
        testS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.testS3Uri)
      .optionallyWith(
        labelDelimiter.map(value =>
          LabelDelimiter.unwrap(value): java.lang.String
        )
      )(_.labelDelimiter)
      .optionallyWith(
        augmentedManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.augmentedManifests)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(documents.map(value => value.buildAwsValue()))(
        _.documents
      )
      .optionallyWith(documentReaderConfig.map(value => value.buildAwsValue()))(
        _.documentReaderConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierInputDataConfig
      .wrap(buildAwsValue())
}
object DocumentClassifierInputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierInputDataConfig =
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig(
        dataFormat.map(value => value),
        s3Uri.map(value => value),
        testS3Uri.map(value => value),
        labelDelimiter.map(value => value),
        augmentedManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentType.map(value => value),
        documents.map(value => value.asEditable),
        documentReaderConfig.map(value => value.asEditable)
      )
    def dataFormat
        : Optional[zio.aws.comprehend.model.DocumentClassifierDataFormat]
    def s3Uri: Optional[S3Uri]
    def testS3Uri: Optional[S3Uri]
    def labelDelimiter: Optional[LabelDelimiter]
    def augmentedManifests: Optional[
      List[zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly]
    ]
    def documentType: Optional[
      zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat
    ]
    def documents: Optional[
      zio.aws.comprehend.model.DocumentClassifierDocuments.ReadOnly
    ]
    def documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly]
    def getDataFormat: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierDataFormat
    ] = AwsError.unwrapOptionField("dataFormat", dataFormat)
    def getS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
    def getTestS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("testS3Uri", testS3Uri)
    def getLabelDelimiter: ZIO[Any, AwsError, LabelDelimiter] =
      AwsError.unwrapOptionField("labelDelimiter", labelDelimiter)
    def getAugmentedManifests: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("augmentedManifests", augmentedManifests)
    def getDocumentType: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat
    ] = AwsError.unwrapOptionField("documentType", documentType)
    def getDocuments: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierDocuments.ReadOnly
    ] = AwsError.unwrapOptionField("documents", documents)
    def getDocumentReaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("documentReaderConfig", documentReaderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
  ) extends zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly {
    override val dataFormat
        : Optional[zio.aws.comprehend.model.DocumentClassifierDataFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataFormat())
        .map(value =>
          zio.aws.comprehend.model.DocumentClassifierDataFormat.wrap(value)
        )
    override val s3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val testS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.testS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val labelDelimiter: Optional[LabelDelimiter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelDelimiter())
        .map(value => zio.aws.comprehend.model.primitives.LabelDelimiter(value))
    override val augmentedManifests: Optional[
      List[zio.aws.comprehend.model.AugmentedManifestsListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.augmentedManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.AugmentedManifestsListItem.wrap(item)
        }.toList
      )
    override val documentType: Optional[
      zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentType())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierDocumentTypeFormat
          .wrap(value)
      )
    override val documents: Optional[
      zio.aws.comprehend.model.DocumentClassifierDocuments.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documents())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierDocuments.wrap(value)
      )
    override val documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentReaderConfig())
        .map(value => zio.aws.comprehend.model.DocumentReaderConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig
  ): zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly =
    new Wrapper(impl)
}
