package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ClientRequestTokenString,
  ComprehendFlywheelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartFlywheelIterationRequest(
    flywheelArn: ComprehendFlywheelArn,
    clientRequestToken: Optional[ClientRequestTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest = {
    import StartFlywheelIterationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest
      .builder()
      .flywheelArn(ComprehendFlywheelArn.unwrap(flywheelArn): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartFlywheelIterationRequest.ReadOnly =
    zio.aws.comprehend.model.StartFlywheelIterationRequest.wrap(buildAwsValue())
}
object StartFlywheelIterationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StartFlywheelIterationRequest =
      zio.aws.comprehend.model.StartFlywheelIterationRequest(
        flywheelArn,
        clientRequestToken.map(value => value)
      )
    def flywheelArn: ComprehendFlywheelArn
    def clientRequestToken: Optional[ClientRequestTokenString]
    def getFlywheelArn: ZIO[Any, Nothing, ComprehendFlywheelArn] =
      ZIO.succeed(flywheelArn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest
  ) extends zio.aws.comprehend.model.StartFlywheelIterationRequest.ReadOnly {
    override val flywheelArn: ComprehendFlywheelArn =
      zio.aws.comprehend.model.primitives
        .ComprehendFlywheelArn(impl.flywheelArn())
    override val clientRequestToken: Optional[ClientRequestTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest
  ): zio.aws.comprehend.model.StartFlywheelIterationRequest.ReadOnly =
    new Wrapper(impl)
}
