package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.LabelListItem
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentClassificationConfig(
    mode: zio.aws.comprehend.model.DocumentClassifierMode,
    labels: Optional[Iterable[LabelListItem]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassificationConfig = {
    import DocumentClassificationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassificationConfig
      .builder()
      .mode(mode.unwrap)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            LabelListItem.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassificationConfig.ReadOnly =
    zio.aws.comprehend.model.DocumentClassificationConfig.wrap(buildAwsValue())
}
object DocumentClassificationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassificationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassificationConfig =
      zio.aws.comprehend.model
        .DocumentClassificationConfig(mode, labels.map(value => value))
    def mode: zio.aws.comprehend.model.DocumentClassifierMode
    def labels: Optional[List[LabelListItem]]
    def getMode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.DocumentClassifierMode] =
      ZIO.succeed(mode)
    def getLabels: ZIO[Any, AwsError, List[LabelListItem]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassificationConfig
  ) extends zio.aws.comprehend.model.DocumentClassificationConfig.ReadOnly {
    override val mode: zio.aws.comprehend.model.DocumentClassifierMode =
      zio.aws.comprehend.model.DocumentClassifierMode.wrap(impl.mode())
    override val labels: Optional[List[LabelListItem]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.primitives.LabelListItem(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassificationConfig
  ): zio.aws.comprehend.model.DocumentClassificationConfig.ReadOnly =
    new Wrapper(impl)
}
