package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendModelArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEndpointResponse(
    desiredModelArn: Optional[ComprehendModelArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse = {
    import UpdateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse
      .builder()
      .optionallyWith(
        desiredModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.desiredModelArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly =
    zio.aws.comprehend.model.UpdateEndpointResponse.wrap(buildAwsValue())
}
object UpdateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.UpdateEndpointResponse =
      zio.aws.comprehend.model
        .UpdateEndpointResponse(desiredModelArn.map(value => value))
    def desiredModelArn: Optional[ComprehendModelArn]
    def getDesiredModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("desiredModelArn", desiredModelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse
  ) extends zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly {
    override val desiredModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse
  ): zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
